# ita38.inc
# amended 20 Mar 2005 by Andrew.S.Davidson
#
# 1. units in Albania moved to Taranto and formation renamed
# 2. IC raw materials increased to give buffer stock of 6 months imports
# 3. Increase interventionism to encourage to join Axis.
# 4. add AI link

# amended 30 Mar 2005 by Marcus Olausson
# 5. fixed ship name typos

# Andrew S.Davidson 9-Apr-2005
# amended techs to remove imp armoured car and imp. air transport
# reduce cost of battleships under construction from 9 to 3 as they were built over 6 years, not HoI's 2 years

# 17 April 2005 - add famous airbase at Foggia, naval base at Naples and resize other bases and AA to more realistic levels
# ASD             reduce huge oil/supply stockpile in Assab

# 29-May-05 ASD - tweak techs

# 20-Jul-05 ASD - naval doctrines
# 18-Sep-05 ASD - reduce infantry to 1918 quality and remove reserves
#               - cutback AA
#               - change naval bombers to tac (didn't use torpedoes until 1941, using feeble level bombing before then)
# 30-Oct-05 ASD - add Vallo Alpino and other fortifications.  Remove some doctrines to reduce morale and org.

province = { id = 368 # Genoa
	ic = 6	}

province = { id = 379 # Ferrara
	ic = 1	}

province = { id = 513 # Firenze
	ic = 2	}

province = { id = 516 # Perugia
	ic = 3	}

province = { id = 523 # Taranto
	ic = 1	}

province = { id = 531 # Torino
	ic = 3	}

# The Regia Marina classified the various bases into various categories.
# Only La Spezia and Taranto were considered first class bases and equipped with a military shipyard.
# Naples, La Maddalena (Sardinia), Venice, Pola (Pula in Croatia), Brindisi, Leros (Greece), Tobruk (Libya) and Massaua
# (Eritrea) were considered bases of second class,
# while Cagliari, Messina, Augusta, Trapani and Assab (Italian East Africa) were of third class.
# Other ports, amongst them Portoferraio, Gaeta, Reggio Calabria, Palermo, Valona (Albania), Ancona, Pantelleria, Tripoli # (Libya), Bengasi (Libya), Rodos (Greece) and Chisimaio (Somalia) were just considered temporary bases. It should be noted
# that Genoa, a large port, does not appear in the list.

province = { id = 368 # Genoa
	anti_air = 1
	landfort = 3
	naval_base = { size = 2 current_size = 2 }
	air_base = { size = 4 current_size = 4 }}

province = { id = 369 # La Spezia
	anti_air = 1
	naval_base = {size = 10	current_size = 10 }
	air_base = {size = 4 current_size = 4 }}

province = { id = 370 # Milan
	anti_air = 1
	landfort = 1
	air_base = { size = 4 current_size = 4 }}

province = { id = 371 # Trento
	landfort = 3
	air_base = { size = 4 current_size = 4 }}

province = {id = 378 # Venice
	anti_air = 1
	landfort = 4
	naval_base = { size = 4	current_size = 4 }
	air_base = { size = 4 current_size = 4 }}

province = { id = 399 # Rhodes
	air_base = { size = 1 current_size = 1 }}

province = { id = 512   anti_air = 1 } #Bologna

province = { id = 513 #Firenze
	coastalfort = 1
	anti_air = 1 } 

province = { id = 514 #Rimini
	coastalfort = 1
	anti_air = 1 } 

province = { id = 515 # Rome
	anti_air = 1
	air_base = { size = 4 current_size = 4 }}

province = { id = 520 # Foggia
	air_base = { size = 4 current_size = 4 }}

province = { id = 521 #Naples
	air_base = { size = 2 current_size = 2 }
	naval_base = { size = 4	current_size = 4 }}

province = { id = 523 # Taranto
	anti_air = 1
	coastalfort = 1
	naval_base = { size = 10 current_size = 10 }
	air_base = { size = 2 current_size = 2 }}

province = { id = 525 # Palermo
	coastalfort = 1
	naval_base = { size = 1	current_size = 1 }
	air_base = { size = 2 current_size = 2 }}

province = { id = 526 # Catania
	coastalfort = 1	}

province = { id = 531 # Turin
	anti_air = 1
	landfort = 3
	air_base = { size = 4 current_size = 4 }}

province = { id = 534 # Sardinia
	coastalfort = 1
	naval_base = { size = 2	current_size = 2 }
	air_base = { size = 2 current_size = 2 }}

province = { id = 919 #Tobruk
	landfort = 3
	naval_base = { size = 2 current_size = 2 }
	air_base = { size = 2 current_size = 2 }}

province = { id = 924 #Bengasi
	naval_base = { size = 1	current_size = 1 }
	air_base = { size = 4 current_size = 4 }}

province = { id = 932 # Tripoli
	naval_base = { size = 1	current_size = 1 }
	air_base = { size = 2 current_size = 2 }}

province = { id = 1033 # Massaua
	naval_base = { size = 2	current_size = 2 }
	air_base = { size = 2 current_size = 2 }}

province = { id = 1038 # Assab
	naval_base = { size = 1 current_size = 1 }
	air_base = { size = 1 current_size = 1 }} 

#Supplypools
province = {  id = 390  oilpool = 100 supplypool = 500 } # Tirana
province = {  id = 399  oilpool = 100 supplypool = 500 } # Rhodes
province = {  id = 534  oilpool = 100 supplypool = 500 } # Sardinia
province = {  id = 932  oilpool = 100 supplypool = 500 } # Tripoli
province = {  id = 1033  oilpool = 100 supplypool = 500 } # Massaua
province = {  id = 1038  oilpool = 100 supplypool = 500 } # Assab
province = {  id = 1056  oilpool = 100 supplypool = 500 } # Mogadishu

country = {
    tag = ITA

	manpower = 460

	policy = {
        date = { year = 0 month = january day = 0 }
        democratic = 2
        political_left = 3
        freedom = 4
        free_market = 5    # state sponsored cartels
        professional_army = 3
        defense_lobby = 7
        interventionism = 9
    }

	headofstate = { type = 9 id = 3001 }
	headofgovernment = { type = 9 id = 3002 }
 	foreignminister = { type = 9 id = 3003 }
 	armamentminister = { type = 9 id = 3004 }
 	ministerofsecurity = { type = 9 id = 3005 }
 	ministerofintelligence = { type = 9 id = 3006 }
 	chiefofstaff = { type = 9 id = 3007 }
 	chiefofarmy = { type = 9 id = 3008 }
 	chiefofnavy = { type = 9 id = 3009 }        
 	chiefofair = { type = 9 id = 3010 }

	# Resource Reserves (set to 6 months imports for energy, metal and rares)
	energy		= 18720   
	metal		= 9900		
	rare_materials	= 2340	
	oil 		= 1000	
	supplies	=  500
	money 		=  100

	capital = 515
	belligerence = 5
	
	ai = "ITA_1936.ai"

	ownedprovinces =      {
		525 526 524 523 522 521 520 519 518 517 516 515 513 514  512 379 369 368 531 370 371 378 534
		398
		399 #Rhodes
		927 933 932 930 929 925 924 923 922 921 920 919 916 917 918 926 928 931 1017 1018 1016 1015 #Libya
		1033 1039 1038 #Eritrea
		1034 1055 1056 1058 #Somaliland
		1044 1048 1049 1042 1043 1050 1045 1046 1047 1053 1052 1051 1054 #Ethiopia
		}
	controlledprovinces = {
		525 526 524 523 522 521 520 519 518 517 516 515 513 514  512 379 369 368 531 370 371 378 534
		398
		399 #Rhodes
		927 933 932 930 929 925 924 923 922 921 920 919 916 917 918 926 928 931 1017 1018 1016 1015 #Libya
		1033 1039 1038 #Eritrea
		1034 1055 1056 1058 #Somaliland
		1044 1048 1049 1042 1043 1050 1045 1046 1047 1053 1052 1051 1054 #Ethiopia
		
	}
	nationalprovinces =   {
		525 526 524 523 522 521 520 519 518 517 516 515 513 514  512 379 369 368 531 370 371 378 534
		381 384 387 388 389 #Illyrian Coast
	}

diplomacy = {
relation = { tag = AFG value = 50 }
relation = { tag = ARG value = 30 }
relation = { tag = AST value = -10 }
relation = { tag = BEL value = -5 }
relation = { tag = BHU value = -10 }
relation = { tag = BUL value = 150 }
relation = { tag = CAN value = -10 }
relation = { tag = CHL value = 30 }
relation = { tag = ENG value = -50 }
relation = { tag = FIN value = 50 }
relation = { tag = FRA value = -50 }
relation = { tag = GER value = 100 }
relation = { tag = GRE value = -100 }
relation = { tag = HOL value = -20 }
relation = { tag = HUN value = 125 }
relation = { tag = IRQ value = 25 }
relation = { tag = NEP value = -10 }
relation = { tag = NZL value = -10 }
relation = { tag = OMN value = 50 }
relation = { tag = POR value = 65 }
relation = { tag = ROM value = 50 }
relation = { tag = SAF value = -50 }
relation = { tag = SCH value = 0 guaranteed = { day = 16 month = may year = 1935 }  }
relation = { tag = SPA value = 50 guaranteed = { day = 18 month = november year = 1936 } }
relation = { tag = TUR value = 0 }
relation = { tag = YEM value = 50 }
relation = { tag = YUG value = 75 }
}


transports = 200  #3.5 million tons = one sixth of UK
escorts = 35

techapps = {
1010 # Great War Infantry
1020 # Early Infantry
1070 # Basic Para
1110 # Early Mountain
1190 # Great War Cavalry Division
1200 # Early Cavalry Division
1210 # Basic Cavalry Division
1220 # Semi-motorised Cavalry
1230 # Basic Motorized Infantry
2010 # Great War Tank
2020 # Tankette
2030 # Early Tank
2150 # Basic Armoured Car
2290 # Great War Light Field Artillery
2300 # Great War Medium Field Artillery
2310 # Great War Heavy Field Artillery
2320 # Early Field Artillery
2330 # Basic Artillery
2400 # Early AT
2450 # Great War Static AA
2460 # Early Static AA
2510 # Basic AA
3010 # Great War Destroyer
3020 # Early Destroyer
3030 # Basic Destroyer
3070 # Great War Light Cruiser
3080 # Early Light Cruiser
3090 # Basic Light Cruiser
3100 # Improved Light Cruiser
3130 # Great War Heavy Cruiser
3140 # Early Heavy Cruiser
3150 # Basic Heavy Cruiser
3190 # Great War Battlecruiser
3200 # Early Battlecruiser
3210 # Basic Battlecruiser
3250 # Great War Battleship
3260 # Early Battleship
3270 # Basic Battleship
3280 # Imp. Battleship
3320 # Great War Air Carrier
3330 # Early Air Carrier
3400 # Dive Boat
3410 # Short Range Submarine
3420 # Medium Range Submarine
4010 # Interwar Fighter
4020 # Early Fighter 
4050 # Basic Escort
4120 # Interwar Bomber
4130 # Early Bomber
4170 # Basic CAS
4250 # Basic Air transport
5010 # Modern Agriculture
5050 # Basic Machine Tools
5080 # Basic Construction Engineering
5090 # Improved Construction Engineering
5190 # Basic Oil Refining
5200 # Improved Oil Refining
5310 # Census Tabulating Machine
5320 # Basic Computing Machine
5470 # Faculty of Atomic Research
5480 # Atomic Research Laboratories
6210 # Mobility Focus
8020 # Naval Firepower Doctrine
8040 # Fleet Auxiliary Submarine Doctrine
8050 # Convoy Sailing
9010 # Air Superiority Doctrine
9020 # Flying Circus Doctrine
9030 # Force Substitution Doctrine
9040 # Battlefield Destruction
9050 # Dive Bombing
9140 # Strategic Destruction Doctrine
}


landunit = {location = 531 #Torino
		name = "1žII "	id = { type = 30026 id = 1 }        	
division = {id = { type = 30026 id = 5 }
		name = "4'άŵ'ʦ " type = infantry strength  = 70 max_strength = 70 }	
division = {id = { type = 30026 id = 33 } 
		name = "33''ʦ "	type = infantry strength  = 56 max_strength = 70 }
division = {id = { type = 30026 id = 34 } 
		name = "36''ʦ "	type = infantry strength  = 42 max_strength = 70 }	
division = {id = { type = 30026 id = 66 }
	 	name = "4'˹'ɽʦ " type = bergsjaeger strength  = 56 max_strength = 70 }}

	landunit = {
		location = 368 #Genova
		name = "1žIII "
        	id = { type = 30026 id = 100 } 
        	
        division = {
	        id = { type = 30026 id = 4 } 
			name = "3''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 7 } 
			name = "6'ڰ'ʦ "
			type = infantry 
			strength  = 63
			max_strength = 70
				}	
     }  
     landunit = {
		location = 368 #Genova
		name = "1žXV "
        	id = { type = 30026 id = 101 } 
        	
        division = {
	        id = { type = 30026 id = 6 } 
			name = "5''ʦ "
			type = infantry 
			strength  = 63
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 35 } 
			name = "37'Ħ'ʦ "
			type = infantry 
			strength  = 63
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 38 } 
			name = "44'ī'ʦ "
			type = infantry 
			extra = anti_tank brigade_model = 0
			strength  = 56
			max_strength = 70
				}		
     }   
     landunit = {
		location = 371 #Trento
		name = "1žԤ "
        	id = { type = 30026 id = 102 } 
        	
        division = {
	        id = { type = 30026 id = 67 } 
			name = "5'˹'ɽʦ "
			type = bergsjaeger
			strength  = 49
			max_strength = 70
				}
     }  
     landunit = {
		location = 371 #Trento
		name = "4ž˹ "
        	id = { type = 30026 id = 103 } 
        	
        division = {
	        id = { type = 30026 id = 63 } 
			name = "1'ͼ˹'ɽʦ "
			type = bergsjaeger
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 64 } 
			name = "2'׵ŵ'ɽʦ "
			type = bergsjaeger
			strength  = 49
			max_strength = 70
				}
     }  
     landunit = {
		location = 531 #Torino
		name = "4žI "
        	id = { type = 30026 id = 104 } 
        
        division = {
	        id = { type = 30026 id = 2 } 
			name = "1''ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}	
        division = {
	        id = { type = 30026 id = 24 } 
			name = "24'Ƥ³'ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 51 } 
			name = "59''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
     }  	 			 		 		
	 landunit = {
		location = 531 #Torino
		name = "4žIV "
        	id = { type = 30026 id = 105 } 
        
		division = {
	        id = { type = 30026 id = 3 } 
			name = "2'˹˹'ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 26 } 
			name = "26'ɪ'ʦ "
			type = infantry 
			extra = artillery brigade_model = 1
			strength  = 35
			max_strength = 70
				}
     }  	 		
     landunit = {
		location = 378 #Venezia
		name = "2žV "
        	id = { type = 30026 id = 106 } 
        	
        division = {
	        id = { type = 30026 id = 12 } 
			name = "12''ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 15 } 
			name = "15'Ī'ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 49 } 
			name = "57'װ͵'ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
     }  	 	
     landunit = {
		location = 378 #Venezia
		name = "2žXI "
        	id = { type = 30026 id = 107 } 
        
		division = {
	        id = { type = 30026 id = 13} 
			name = "13''ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 14 } 
			name = "14''ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
     }  
     landunit = {
		location = 378 #Venezia
		name = "6ž "
        	id = { type = 30026 id = 108 } 
        
		division = {
	        id = { type = 30026 id = 68 } 
			name = "1'ŷ¡ϡ'ʦ "
			type = cavalry 
			model = 2
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 69 } 
			name = "2'Ŭ'ʦ "
			type = cavalry 
			model = 2
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 70 } 
			name = "3'˹'ʦ "
			type = cavalry
			model = 2
			extra = artillery brigade_model = 1
			strength  = 49
			max_strength = 70
				}
     }  
     landunit = {
		location = 378 #Venezia
		name = "6žе "
        	id = { type = 30026 id = 109 } 
        
		division = {
	        id = { type = 30026 id = 61 } 
			name = "101'˹'ʦ "
			type = motorized
			extra = armored_car
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 62 } 
			name = "102''ʦ "
			type = motorized
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 59 } 
			name = "132''װʦ "
			type = light_armor
			model = 0
			extra = armored_car
			strength  = 56
			max_strength = 70
				}
     }  
     landunit = {
		location = 378 #Venezia
		name = "6ž "
        	id = { type = 30026 id = 110 } 
        
		division = {
	        id = { type = 30026 id = 9 } 
			name = "9'ձȰ'ʦ "
			type = cavalry
			model = 3
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 10 } 
			name = "10'ƤΤ'ʦ "
			type = cavalry
			model = 3
			strength  = 42
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 44 } 
			name = "52''ʦ "
			type = cavalry
			model = 3
			extra = armored_car
			strength  = 42
			max_strength = 70
				}
     }
     landunit = {
		location = 371 #Trento
		name = "8žXIV "
        	id = { type = 30026 id = 111 } 
        
		division = {
	        id = { type = 30026 id = 32 } 
			name = "32''ʦ "
			type = infantry 
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 36 } 
			name = "38''ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}
     }  	
     landunit = {
		location = 514 #Rimini
		name = "8žVI "
        	id = { type = 30026 id = 112 } 
        
		division = {
	        id = { type = 30026 id = 18 } 
			name = "18'ī'ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 41 } 
			name = "49''ʦ "
			type = infantry 
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 48 } 
			name = "56''ʦ "
			type = infantry 
			strength  = 49
			max_strength = 70
				}
     }  	
     landunit = {
		location = 525 #Messina
		name = "ϷžXII "
        	id = { type = 30026 id = 113 } 
        
		division = {
	        id = { type = 30026 id = 28 } 
			name = "28'˹'ʦ "
			type = infantry 
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 46 } 
			name = "54'ǲ'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
     }  	
     landunit = {
		location = 534 #Sardegna
		name = "ϷžXIII "
        	id = { type = 30026 id = 114 } 
        
		division = {
	        id = { type = 30026 id = 30 } 
			name = "30''ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 31 } 
			name = "31''ʦ "
			type = infantry 
			strength  = 42
			max_strength = 70
				}
     }  	
     landunit = {
		location = 523 #Tirana
		name = "ָӲ "
        	id = { type = 30026 id = 115 } 
        
		division = {
	        id = { type = 30026 id = 19 } 
			name = "19'άٲ'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 23 } 
			name = "23''ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 45 } 
			name = "53''ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 65 } 
			name = "3''ʦ "
			type = bergsjaeger
			strength  = 63
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 58 } 
			name = "131''װʦ "
			type = light_armor
			model = 0
			extra = armored_car
			strength  = 63
			max_strength = 70
				}
     } 
     landunit = {
		location = 524 #Cosenza
		name = "3žIX "
        	id = { type = 30026 id = 116 } 
        
		division = {
	        id = { type = 30026 id = 29 } 
			name = "29'Ƥ'ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 39 } 
			name = "47''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 40 } 
			name = "48''ʦ "
			type = infantry 
			strength  = 49
			max_strength = 70
				}
     }
     landunit = {
		location = 513 #Firenze
		name = "7žVII "
        	id = { type = 30026 id = 117 } 
        
		division = {
	        id = { type = 30026 id = 20 } 
			name = "20''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 37 } 
			name = "41''ʦ "
			type = infantry 
			strength  = 49
			max_strength = 70
				}
     }
     landunit = {
		location = 515 #Roma
		name = "7žVIII "
        	id = { type = 30026 id = 118 } 
        
		division = {
	        id = { type = 30026 id = 21 } 
			name = "21''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 43 } 
			name = "51'Ү'ʦ "
			type = infantry 
			extra = artillery brigade_model = 1
			strength  = 56
			max_strength = 70
				}
     }
     landunit = {
		location = 399 #Rodi
		name = "ٺȺ "
        	id = { type = 30026 id = 119 } 
        
		division = {
	        id = { type = 30026 id = 42 } 
			name = "50'׼'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
     }
     landunit = {
		location = 932 #Tripoli
		name = "5žX "
        	id = { type = 30026 id = 120 } 
        
		division = {
	        id = { type = 30026 id = 25 } 
			name = "25''ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 47 } 
			name = "55''ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
     }
     landunit = {
		location = 919 #Tobruk
		name = "5žXX "
        	id = { type = 30026 id = 121 } 
        
		division = {
	        id = { type = 30026 id = 17 } 
			name = "17'ά'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 27 } 
			name = "27''ʦ "
			type = infantry 
			strength  = 35
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 53 } 
			name = "61''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
     } 
     landunit = {
		location = 932 #Tripoli
		name = "5žXXIII "
        	id = { type = 30026 id = 122 } 
        
		division = {
	        id = { type = 30026 id = 72 } 
			name = "1'23'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
			experience = 30
				}
		division = {
	        id = { type = 30026 id = 73 } 
			name = "2'ʮ28'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
			experience = 30
				}
     } 	
     landunit = {
		location = 919 #Tobruk
		name = "10žXXI "
        	id = { type = 30026 id = 123 } 
        
		division = {
	        id = { type = 30026 id = 54 } 
			name = "62'￨'ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 55 } 
			name = "63''ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
     } 	
     landunit = {
		location = 924 #Bengazi
		name = "10žXXII "
        	id = { type = 30026 id = 124 } 
        
		division = {
	        id = { type = 30026 id = 56 } 
			name = "64'̹'ʦ "
			type = infantry 
			strength  = 56
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 75 } 
			name = "4'һ3'ʦ "
			type = infantry 
			strength  = 70
			max_strength = 70
			experience = 30
				}
     } 	
     landunit = {
		location = 919 #Tobruk
		name = "10žפ "
        	id = { type = 30026 id = 125 } 
        
		division = {
	        id = { type = 30026 id = 74 } 
			name = "3'21'ʦ "
			type = infantry 
			strength  = 21
			max_strength = 70
			experience = 30
				}
		division = {
	        id = { type = 30026 id = 76 } 
			name = "ʦ "
			type = militia
			strength  = 10
			max_strength = 70
				}
     } 	
     landunit = {
		location = 1033 #Asmara
		name = "Ǿ "
        	id = { type = 30026 id = 126 } 
        
		division = {
	        id = { type = 30026 id = 57 } 
			name = "''ʦ "
			type = infantry 
			strength  = 63
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 71 } 
			name = "''ʦ "
			type = militia
			strength  = 10
			max_strength = 70
				}
     }
     landunit = {
		location = 1039 #Massaua
		name = "Ǿűפ "
        	id = { type = 30026 id = 127 } 
        
		division = {
	        id = { type = 30026 id = 77 } 
			name = "ǵ1ʦ "
			type = militia
			strength  = 49
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 78 } 
			name = "ǵ2ʦ "
			type = militia
			strength  = 42
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 79 } 
			name = "ǵ4ʦ "
			type = militia
			strength  = 42
			max_strength = 70
				}
     }
     landunit = {
		location = 1053 #Magalo
		name = "Ǿϲפ "
        	id = { type = 30026 id = 128 } 
        
		division = {
	        id = { type = 30026 id = 82 } 
			name = "ϲر "
			type = militia
			strength  = 49
			max_strength = 70
				}
     }
     landunit = {
		location = 1047 #Macalle
		name = "ǾŶפ "
        	id = { type = 30026 id = 129 } 
        
		division = {
	        id = { type = 30026 id = 83 } 
			name = "ر "
			type = militia
			strength  = 49
			max_strength = 70
				}
     }
     landunit = {
		location = 1056 #Mogadiscio
		name = "Ǿפ "
        	id = { type = 30026 id = 130 } 
        
		division = {
	        id = { type = 30026 id = 80 } 
			name = "101ʦ "
			type = militia
			strength  = 28
			max_strength = 70
				}
		division = {
	        id = { type = 30026 id = 81 } 
			name = "102ʦ "
			type = militia
			strength  = 21
			max_strength = 70
				}
     } 	
		
airunit = {
 location = 531 # Turin
base = 531
 id = { type = 30026 id = 156 }
 name = "1վ "

    division = {
   id = { type = 30026 id = 157 }
   name = "9߻ " 
   strength = 100 
   type = interceptor
   model = 0
             }
	  }

airunit = {
 location = 531
base = 531
 id = { type = 30026 id = 162 }
 name = "6''սը "

division = {
   id = { type = 30026 id = 165 }
   name = "6''սը " 
   strength = 100 
   type = tactical_bomber
   model = 0
             }
	  }

airunit = {
 location = 531
base = 531
 id = { type = 30026 id = 166 }
 name = "2''߻ "

    division = {
   id = { type = 30026 id = 167 }
   name = "2''߻ " 
   strength = 100 
   type = interceptor
   model = 1
             }
 
	     }


airunit = {
 location = 919
base = 919
 id = { type = 30026 id = 158 }
 name = "4''սը "

    division = {
               id = { type = 30026 id = 159 }
               name = "4''սը " 
               strength = 100 
               type = tactical_bomber
               model = 1
             }
		  }



################################
airunit = {
 location = 523 # Taranto
base = 523
 id = { type = 30026 id = 169 }
 name = "2վ "

	division = {
   id = { type = 30026 id = 205 }
   name = "14'׿˹'߻ " 
   strength = 100 
   type = interceptor
   model = 0
             }
	  }
airunit = {
 location = 523
base = 523
 id = { type = 30026 id = 171 }
 name = "3''ը "

   division = {
   id = { type = 30026 id = 172 }
   name = "3''ը " 
   strength = 100 
   type = tactical_bomber
   model = 1
             }
division = {
   id = { type = 30026 id = 174 }
   name = "24ը " 
   strength = 50 
   type = tactical_bomber
   model = 0
             }
	  }

airunit = {
 location = 523
base = 523
 id = { type = 30026 id = 196 }
 name = "ǵǺվ "

  division = {
   id = { type = 30026 id = 198 }
   name = "38սը " 
   strength = 100 
   type = tactical_bomber
   model = 0
             }
         }


###################################
airunit = {
 location = 525
base = 525
 id = { type = 30026 id = 180 }
 name = "3վ "

  division = {
   id = { type = 30026 id = 181 }
   name = "7߻ " 
   strength = 100 
   type = interceptor
   model = 1
             }
	  }
	  

	
airunit = {
 location = 525
base = 525
 id = { type = 30026 id = 185 }
 name = "8'˹'߻ "

	division = {
		id = { type = 30026 id = 200 }
		name = "8'˹'߻ " 
		strength = 100 
		type = interceptor
		model = 0
	}
}
##########################################
airunit = {
 location = 378
base = 378
 id = { type = 30026 id = 188 }
 name = "4վ "

    division = {
   id = { type = 30026 id = 189 }
   name = "35սԺը " 
   strength = 100 
   type = tactical_bomber
   model = 1
             }

	}

	airunit = {
		location = 534
		base = 534
		id = { type = 30026 id = 192 }
		name = "վ "
  
  division = {
   id = { type = 30026 id = 168 }
   name = "53߻ " 
   strength = 100 
   type = interceptor
   model = 1
            }
  division = {
   id = { type = 30026 id = 195 }
   name = "190ը " 
   strength = 60 
   type = cas
   model = 0
            }
		division = {
		id = { type = 30026 id = 201 }
		name = "50ը " 
		strength = 50 
		type = cas
		model = 0
		}
	}
#################################################
airunit = {
 location = 932
base = 932
 id = { type = 30026 id = 199 }
 name = "ǿվ "

	division = {
   id = { type = 30026 id = 186 }
   name = "9߻ " 
   strength = 100 
   type = interceptor
   model = 0
             }
    
division = {
   id = { type = 30026 id = 202 }
   name = "15/33սը " 
   strength = 50 
   type = tactical_bomber
   model = 0
            }
         }
############################################
airunit = {
 location = 924
base = 924
 id = { type = 30026 id = 204 }
 name = "ǿվ "

	division = {
   id = { type = 30026 id = 170 }
   name = "33߻ " 
   strength = 100 
   type = interceptor
   model = 0
             }
    
  division = {
   id = { type = 30026 id = 206 }
   name = "13'ϼ'սԺը " 
   strength = 100 
   type = tactical_bomber
   model = 0
             }
         }

############################
navalunit = {
 id = { type = 30026 id = 212 }
 name = " "
 location = 523
base = 523

  division = { id = { type = 30026 id = 400 } name = "ʥκ " type = heavy_cruiser model = 0 }
  division = { id = { type = 30026 id = 401 } name = "к " type = light_cruiser model = 0 }
  division = { id = { type = 30026 id = 402 } name = " " type = light_cruiser model = 0 }
  division = { id = { type = 30026 id = 213 } name = "2֧ " type = destroyer model = 0 }
  division = { id = { type = 30026 id = 322 } name = "3֧ " type = destroyer model = 0 }
  division = { id = { type = 30026 id = 323 } name = "4֧ " type = destroyer model = 0 }
  division = { id = { type = 30026 id = 324 } name = "5֧ " type = destroyer model = 0 }
  division = { 
   id = { type = 30026 id = 214 }
   name = "6֧ "
   type = destroyer 
   model = 1
             }
	}
###################################

navalunit = {
 id = { type = 30026 id = 215 }
 name = "1 "
 location = 523
base = 523

  	division = { id = { type = 30026 id = 216 } name = "¡ " type = battleship model = 0 }
	division = { id = { type = 30026 id = 320 } name = "-Ǻ " type = battleship model = 0 }
	division = { id = { type = 30026 id = 321 } name = "Լº " type = battleship model = 0 }
	}

  navalunit = {
 id = { type = 30026 id = 217 }
 name = "1ӵ1ֶ "
 location = 523
base = 523

  division = { 
   id = { type = 30026 id = 218 }
   name = " "
   type = heavy_cruiser
   model = 2
               }
  division = { 
   id = { type = 30026 id = 219 }
   name = "Ǻ "
   type = heavy_cruiser
   model = 2
   		}
  division = { 
   id = { type = 30026 id = 220 }
   name = "ķ "
   type = heavy_cruiser
   model = 2
   		}
  division = { 
   id = { type = 30026 id = 221 }
   name = "9֧ "
   type = destroyer
   model = 1
   	}
	}
   navalunit = {
 id = { type = 30026 id = 222 }
 name = "1ӵ4ֶ "
 location = 378
base = 378

  division = { 
   id = { type = 30026 id = 223 }
   name = "￨ͱŵ "
   type = light_cruiser
   model = 1
   maxspeed = 34
               }
  division = { 
   id = { type = 30026 id = 224 }
   name = "·׼ɺ "
   type = light_cruiser
   model = 1
   		}
  division = { 
   id = { type = 30026 id = 225 }
   name = "Сŵ "
   type = light_cruiser
   model = 1
   maxspeed = 34
   		}
  division = { 
   id = { type = 30026 id = 226 }
   name = "¡Ⱥ "
   type = light_cruiser
   model = 1
   		}
  division = { 
   id = { type = 30026 id = 227 }
   name = "12֧ "
   type = destroyer
   model = 1
   		}

	}

 navalunit = {
 id = { type = 30026 id = 228 }
 name = "1ӵ5ֶ "
 location = 378
base = 378

    division = { 
   id = { type = 30026 id = 229 }
   name = "Ӹ "
   type = battleship
   model = 0
   		}
  division = { 
   id = { type = 30026 id = 230 }
   name = "7֧ "
   type = destroyer
   model = 2
   		}
  division = { 
   id = { type = 30026 id = 231 }
   name = "8֧ "
   type = destroyer
   model = 2
   		}
	}
  navalunit = {
 id = { type = 30026 id = 232 }
 name = "1ӵ8ֶ "
 location = 378
base = 378

    division = { 
   id = { type = 30026 id = 233 }
   name = "³ "
   type = light_cruiser
   model = 3
   maxspeed = 35
   		}
  division = { 
   id = { type = 30026 id = 234 }
   name = "塤ﲨں "
   type = light_cruiser
   model = 3
   maxspeed = 35
   		}
  division = { 
   id = { type = 30026 id = 235 }
   name = "16֧ "
   type = destroyer
   model = 2
   		}
  division = { 
   id = { type = 30026 id = 307 }
   name = "1䴬 "
   type = transport
   model = 0 
            }

	}
  navalunit = {
 id = { type = 30026 id = 236 }
 name = "1ӵ9ֶ "
 location = 378
base = 378

  division = { 
   id = { type = 30026 id = 239 }
   name = "14֧ "
   type = destroyer
   model = 1
   		}
  division = { 
   id = { type = 30026 id = 240 }
   name = "15֧ "
   type = destroyer
   model = 1
   		}
  division = { 
   id = { type = 30026 id = 308 }
   name = "2䴬 "
   type = transport
   model = 0 
            }
	division = { 
   		id = { type = 30026 id = 714 }
   		name = "6䴬 "
   		type = transport
   		model = 0 
	}
	}

####################################
 navalunit = {
 id = { type = 30026 id = 241 }
 name = "2 "
 location = 523
base = 523

  division = { 
   id = { type = 30026 id = 242 }
   name = " "
   type = heavy_cruiser 
   model = 2
            }
	division = { 
   		id = { type = 30026 id = 715 }
   		name = "䴬 "
   		type = transport
   		model = 0 
	}
	division = { 
   		id = { type = 30026 id = 5556 }
   		name = "7䴬 "
   		type = transport
   		model = 0 
	}
	}
  navalunit = {
 id = { type = 30026 id = 243 }
 name = "2ӵ2ֶ "
 location = 523
base = 523

  division = { 
   id = { type = 30026 id = 244 }
   name = "¡׺ "
   type = light_cruiser
   model = 1
   maxspeed = 34
               }
  division = { 
   id = { type = 30026 id = 245 }
   name = "÷¡װ "
   type = light_cruiser
   model = 1
   maxspeed = 34
   		}
    division = { 
   id = { type = 30026 id = 246 }
   name = "10֧ "
   type = destroyer
   model = 0
   	}
   	division = { 
   		id = { type = 30026 id = 716 }
   		name = "ɡ䴬 "
   		type = transport
   		model = 0 
	}
	}
   navalunit = {
 id = { type = 30026 id = 247 }
 name = "2ӵ3ֶ "
 location = 523
base = 523

  division = { 
   id = { type = 30026 id = 248 }
   name = "к "
   type = heavy_cruiser
   model = 1
               }
  division = { 
   id = { type = 30026 id = 249 }
   name = "ŵ "
   type = heavy_cruiser
   model = 2
   		}
  division = { 
   id = { type = 30026 id = 250 }
   name = "˹غ "
   type = heavy_cruiser
   model = 1
   		}
    division = { 
   id = { type = 30026 id = 251 }
   name = "11֧ "
   type = destroyer
   model = 0
   	}
   	division = { 
   		id = { type = 30026 id = 717 }
   		name = "䴬 "
   		type = transport
   		model = 0 
	}
	}

 navalunit = {
 id = { type = 30026 id = 252 }
 name = "2ӵ7ֶ "
 location = 523
base = 523

    division = { 
   id = { type = 30026 id = 253 }
   name = "ŷ "
   type = light_cruiser
   model = 2
   maxspeed = 34
   		}
  division = { 
   id = { type = 30026 id = 254 }
   name = "˹ "
   type = light_cruiser
   model = 2
   maxspeed = 34
   		}
  division = { 
   id = { type = 30026 id = 255 }
   name = "ĬȰ¡̹ "
   type = light_cruiser
   model = 2
   maxspeed = 34
   		}
  division = { 
   id = { type = 30026 id = 256 }
   name = "ɶࡤɵ¿ "
   type = light_cruiser
   model = 2
   maxspeed = 34
   		}
  division = { 
   id = { type = 30026 id = 257 }
   name = "13֧ "
   type = destroyer
   model = 0
   	}
   	division = { 
   		id = { type = 30026 id = 718 }
   		name = "貨䴬 "
   		type = transport
   		model = 0 
	}
	}
  
######################################

navalunit = {
 id = { type = 30026 id = 258 }
 name = "ǱͧϽ "
 location = 369
base = 369

  division = { 
   id = { type = 30026 id = 259 }
   name = "4֧ "
   type = destroyer
   model = 0
  }
  
  division = { 
   id = { type = 30026 id = 260 }
   name = "51Ǳ֧ͧ "
   type = submarine
   model = 1
                }
  division = { 
   id = { type = 30026 id = 261 }
   name = "52Ǳ֧ͧ "
   type = submarine
   model = 1
  }
 }
   
navalunit = {
 id = { type = 30026 id = 262 }
 name = "1Ǳͧ "
 location = 369
base = 369

  division = { 
   id = { type = 30026 id = 263 }
   name = "11Ǳ֧ͧ "
   type = submarine
   model = 1
             }
  division = { 
   id = { type = 30026 id = 264 }
   name = "12Ǳ֧ͧ "
   type = submarine
   model = 1
                }
  division = { 
   id = { type = 30026 id = 265 }
   name = "13Ǳ֧ͧ "
   type = submarine
   model = 0
                }
  division = { 
   id = { type = 30026 id = 266 }
   name = "14Ǳ֧ͧ "
   type = submarine
   model = 0
                }
  division = { 
   id = { type = 30026 id = 269 }
   name = "17Ǳ֧ͧ "
   type = submarine
   model = 0
                }
         }

navalunit = {
 id = { type = 30026 id = 273 }
 name = "3Ǳͧ "
 location = 369
base = 369

  division = { 
   id = { type = 30026 id = 274 }
   name = "31Ǳ֧ͧ "
   type = submarine
   model = 2
             }
         }
navalunit = {
 id = { type = 30026 id = 279 }
 name = "4Ǳͧ "
 location = 369
base = 369

  division = { 
   id = { type = 30026 id = 280 }
   name = "40Ǳ֧ͧ "
   type = submarine
   model = 1
             }
  division = { 
   id = { type = 30026 id = 281 }
   name = "41Ǳ֧ͧ "
   type = submarine
   model = 1
                }
  division = { 
   id = { type = 30026 id = 282 }
   name = "42Ǳ֧ͧ "
   type = submarine
   model = 1
             }
  division = { 
   id = { type = 30026 id = 283 }
   name = "43Ǳ֧ͧ "
   type = submarine
   model = 1
                }
         }
navalunit = {
 id = { type = 30026 id = 290 }
 name = "7Ǳͧ "
 location = 369
base = 369

  division = { 
   id = { type = 30026 id = 291 }
   name = "71Ǳ֧ͧ "
   type = submarine
   model = 2
             }

  division = { 
   id = { type = 30026 id = 292 }
   name = "72Ǳ֧ͧ "
   type = submarine
   model = 2
                }
         }
######################################################
navalunit = {
 id = { type = 30026 id = 293 }
 name = "ǺָӲ "
 location = 932
base = 932

  division = { 
   id = { type = 30026 id = 294 }
   name = "1֧ "
   type = destroyer 
   model = 1
             }
	}
  navalunit = {
 id = { type = 30026 id = 295 }
 name = "8Ǳͧ "
 location = 932
base = 932

  division = { 
   id = { type = 30026 id = 296 }
   name = "61Ǳ֧ͧ "
   type = submarine
   model = 1
             }
  division = { 
   id = { type = 30026 id = 297 }
   name = "62Ǳ֧ͧ "
   type = submarine
   model = 1
                }
         }

navalunit = {
 id = { type = 30026 id = 298 }
 name = "캣ָӲ "
 location = 1038
base = 1038

  division = { 
   id = { type = 30026 id = 299 }
   name = "3֧ "
   type = destroyer 
   model = 0
             }
  division = { 
   id = { type = 30026 id = 300 }
   name = "5֧ "
   type = destroyer
   model = 0 
            }
  division = { 
   		id = { type = 30026 id = 719 }
   		name = "ΰ䴬 "
   		type = transport
   		model = 0 
	}
	}
  navalunit = {
 id = { type = 30026 id = 301 }
 name = "8Ǳͧ "
 location = 1038
base = 1038

  division = { 
   id = { type = 30026 id = 302 }
   name = "81Ǳ֧ͧ "
   type = submarine
   model = 1
             }
  division = { 
   id = { type = 30026 id = 303 }
   name = "82Ǳ֧ͧ "
   type = submarine
   model = 1
                }
         }

division_development = {
	name = "º "
	type = battleship
	model = 3
	cost = 3
	id = { type = 30026 id = 500 }
	date = { year = 1940 month = may day = 6 }
	}

division_development = {
	name = "ά¡άк "
	type = battleship
	model = 3
	cost = 3
	id = { type = 30026 id = 501 }
	date = { year = 1940 month = april day = 28 }
	}
   
}